#include "DButton.h"
#include <Windowsx.h>

namespace DWL {
    //! Funcin para crear el Button (CreateWindowEx).
    /*! Esta funcin se usa para crear un Button dinamicamente.
            \fn         HWND Crear(DBaseWnd *nPadre, const TCHAR *nTexto, const int cX, const int cY, const int cAncho, const int cAlto, const UINT cID, DWORD nEstilos);
            \param[in]  nPadre               Clase DBaseWnd que contendra el button.
            \param[in]  nTexto               Texto para el Button.
            \param[in]  cX                   Coordenada X relativa a la ventana padre.
            \param[in]  cY                   Coordenada Y relativa a la ventana padre.
            \param[in]  cAncho               Ancho del Button en pixeles.
            \param[in]  cAlto                Altura del Button en pixeles
            \param[in]  cID                  ID para poder identificar el Button en sus eventos.
            \param[in]  nEstilos             Estilos estandar para el Button.
            \return     Devuelve el HWND del Button o NULL en caso de error.
    */
    HWND DButton::Crear(DBaseWnd *nPadre, const TCHAR *nTexto, const int cX, const int cY, const int cAncho, const int cAlto, const UINT cID, DWORD nEstilos) {            
        if (nPadre == NULL) throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_BaseWndNULL)); 
        _hWnd = CreateWindowEx(NULL, TEXT("BUTTON"), nTexto, nEstilos, cX, cY, cAncho, cAlto, nPadre->hWnd(), reinterpret_cast<HMENU>(IntToPtr(cID)), GetModuleHandle(NULL), NULL); 
		_ConectarControl(cID, nPadre);
        return _hWnd;
    }

    //! Funcin para crear el Button (CreateWindowEx).
    /*! Esta funcin se usa para crear un Button dinamicamente.
            \fn         HWND Crear(DBaseWnd *nPadre, const TCHAR *nTexto, const int cX, const int cY, const int cAncho, const int cAlto, const UINT cID, DButton_Estilos *nEstilos);
            \param[in]  nPadre               Clase DBaseWnd que contendra el button.
            \param[in]  nTexto               Texto para el Button.
            \param[in]  cX                   Coordenada X relativa a la ventana padre.
            \param[in]  cY                   Coordenada Y relativa a la ventana padre.
            \param[in]  cAncho               Ancho del Button en pixeles.
            \param[in]  cAlto                Altura del Button en pixeles
            \param[in]  cID                  ID para poder identificar el Button en sus eventos.
            \param[in]  nEstilos             Puntero a la clase DButton_Estilos que contiene los estilos para el Button.
            \return     Devuelve el HWND del Button o NULL en caso de error.
            \remarks    Esta funcin es mas para depuracin de estilos que para uso cootidiano, ya que las clase DButton_Estilos permite revisar los estilos del button con mucha ms facilidad, pero tambien consumen ms memoria.
    */
    HWND DButton::Crear(DBaseWnd *nPadre, const TCHAR *nTexto, const int cX, const int cY, const int cAncho, const int cAlto, const UINT cID, DButton_Estilos *nEstilos) {
        if (nPadre == NULL) throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_BaseWndNULL)); 
        _hWnd = CreateWindowEx(NULL, TEXT("BUTTON"), nTexto, nEstilos->Estilos(), cX, cY, cAncho, cAlto, nPadre->hWnd(), reinterpret_cast<HMENU>(IntToPtr(cID)), GetModuleHandle(NULL), NULL); 
		_ConectarControl(cID, nPadre);
        return _hWnd;
    }

    //! Funcin para asignar esta clase a un Button de un dialogo.
    /*! Esta funcin se usa para asignar esta clase a un Button de un dialogo.
            \fn         HWND Asignar(DBaseWnd *nPadre, const UINT cID);
            \param[in]  nPadre      Clase DBaseWnd que contendra el button.
            \param[in]  cID         ID para poder identificar el Button en sus eventos.
            \return     Devuelve el HWND del Button o NULL en caso de error.
            \remarks    Esta funcin solo debe utilizarse si tenemos un Button en un dialogo de los recursos.
    */
	HWND DButton::Asignar(DBaseWnd *nPadre, const UINT cID) { 
        if (nPadre == NULL) throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_BaseWndNULL)); 
		_hWnd = GetDlgItem(nPadre->hWnd(), cID);
		_ConectarControl(cID, nPadre); 
		return _hWnd;
	};

    //! Funcin para asignar el texto del button.
    /*! Esta funcin se usa para asignar el texto del button.
            \fn         void AsignarTexto(const TCHAR *nTexto);
            \param[in]  nTexto   Nuevo texto para el button.
            \return     No devuelve nada.
            \sa         ObtenerTexto().
    */
    void DButton::AsignarTexto(const TCHAR *nTexto) {
        SetDlgItemText(GetParent(_hWnd), static_cast<int>(GetWindowLongPtr(_hWnd, GWL_ID)), nTexto); 
    }

    //! Funcin para obtener el texto del button.
    /*! Esta funcin se usa para obtener el texto del button.
            \fn         void ObtenerTexto(DString &nTexto);
            \param[out] nTexto   Clase DString donde se almacenara el texto del button.
            \return     No devuelve nada.
            \sa         AsignarTexto().
    */
    void DButton::ObtenerTexto(DString &nTexto) {
        TCHAR Buffer[256];
        GetDlgItemText(GetParent(_hWnd), static_cast<int>(GetWindowLongPtr(_hWnd, GWL_ID)), Buffer, 256);
        nTexto = Buffer;
    }


    //! Funcin que retorna los estilos del Button.
    /*  Esta funcin introduce en el parametro nEstilos los estilos que contiene el Button.
            \fn         void ObtenerEstilos(DListView_Estilos &nEstilos);
            \param[out] nEstilos : Clase DButton_Estilos en la que se depositaran los estilos del Button.
            \return     Esta funcin no devuelve nada.
    */
    void DButton::ObtenerEstilos(DButton_Estilos &nEstilos) { 
        nEstilos = static_cast<DWORD>(GetWindowLongPtr(_hWnd, GWL_STYLE)); 
    };

    //! Funcin que retorna los estilos del Button.
    /*  Esta funcin retorna todos los estilos del Button.
            \fn         DWORD ObtenerEstilos(void);
            \return     Devuelve los estilos del Button.
    */
    DWORD DButton::ObtenerEstilos(void) {
        return static_cast<DWORD>(GetWindowLongPtr(_hWnd, GWL_STYLE));
    }

    //! Funcin para asignar los estilos del Button.
    /*  Esta funcin permite asignar uno o mas estilos mediante el parametro nEstilos previamente preparado
            \fn         void AsignarEstilos(DButton_Estilos &nEstilos)
            \param[in]  nEstilos : Clase DButton_Estilos que contiene los nuevos estilos a asignar.
            \return     No devuelve nada.
            \remarks    Esta funcin esta pensada para modificar todos los estilos de golpe, por lo que si quieres modificar un solo estilo conservando los valores de los demas,
                        primero deberas obtener los estilos mediante la funcin ObtenerEstilos(), para luego modificar lo que te interese, y finalmente pasar la
                        clase DButton_Estilos a esta funcin.
    */
    void DButton::AsignarEstilos(DButton_Estilos &nEstilos) { 
        SetWindowLongPtr(_hWnd, GWL_STYLE, nEstilos());
    };

    //! Funcin para asignar los estilos del Button.
    /*  Esta funcin permite asignar uno o mas estilos mediante el parametro nEstilos previamente preparado
            \fn         void AsignarEstilos(DWORD nEstilos)
            \param[in]  nEstilos : DWORD que contiene los nuevos estilos a asignar.
            \return     No devuelve nada.
            \remarks    Esta funcin esta pensada para modificar todos los estilos de golpe, por lo que si quieres modificar un solo estilo conservando los valores de los demas,
                        primero deberas obtener los estilos mediante la funcin ObtenerEstilos(), para luego modificar lo que te interese, y finalmente pasar los estilos a esta funcin
    */
    void DButton::AsignarEstilos(DWORD nEstilos) { 
        SetWindowLongPtr(_hWnd, GWL_STYLE, nEstilos);
    };
};